/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Window
extends JFrame {
    private JTextField TextFieldHeight;
    private JTextField TextFieldCreatinine;
    private JTextField TextFieldAge;
    private JTextField TextFieldCystatin;
    private JTextField TextFieldResult;
    private JLabel labelSex;
    private JLabel labelHeight;
    private JLabel labelCm;
    private JLabel labelCreatinine;
    private JLabel labelAge;
    private JLabel labelCystatin;
    private JLabel labelYear;
    private JLabel labelCHUV;
    private JLabel labelDummy;
    private JComboBox comboboxCreatinine;
    private JComboBox comboboxSex;
    private boolean valid = Boolean.FALSE;
    private JButton buttonCompute;
    private Window me = this;
    private JPanel panel;

    public Window() {
        this.setTitle("Quadratic Formula for Glomerular Filtration Rate in Children");
        this.setBounds(0, 0, 650, 300);
        this.setResizable(Boolean.FALSE);
        this.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        this.labelSex = new JLabel("Sex:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.labelSex, gridBagConstraints);
        this.comboboxSex = new JComboBox();
        this.comboboxSex.addItem("Male");
        this.comboboxSex.addItem("Female");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.comboboxSex, gridBagConstraints);
        this.labelHeight = new JLabel("Height [cm]:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.panel.add((Component)this.labelHeight, gridBagConstraints);
        this.TextFieldHeight = new JTextField(6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panel.add((Component)this.TextFieldHeight, gridBagConstraints);
        this.labelCreatinine = new JLabel("Creatinine:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.panel.add((Component)this.labelCreatinine, gridBagConstraints);
        this.TextFieldCreatinine = new JTextField(6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.panel.add((Component)this.TextFieldCreatinine, gridBagConstraints);
        this.comboboxCreatinine = new JComboBox();
        this.comboboxCreatinine.addItem("To select");
        this.comboboxCreatinine.addItem("mg/dl");
        this.comboboxCreatinine.addItem("\u00b5mol/l");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.panel.add((Component)this.comboboxCreatinine, gridBagConstraints);
        this.labelAge = new JLabel("Age [years]:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.panel.add((Component)this.labelAge, gridBagConstraints);
        this.labelCystatin = new JLabel("Cystatin C [mg/l]:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.panel.add((Component)this.labelCystatin, gridBagConstraints);
        this.TextFieldAge = new JTextField(6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.panel.add((Component)this.TextFieldAge, gridBagConstraints);
        this.TextFieldCystatin = new JTextField(6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.panel.add((Component)this.TextFieldCystatin, gridBagConstraints);
        this.buttonCompute = new JButton("Compute");
        EcouteurButtonCompute ecouteurButtonCompute = new EcouteurButtonCompute();
        this.buttonCompute.addActionListener(ecouteurButtonCompute);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.panel.add((Component)this.buttonCompute, gridBagConstraints);
        this.TextFieldResult = new JTextField(20);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        this.panel.add((Component)this.TextFieldResult, gridBagConstraints);
        this.labelDummy = new JLabel(" ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.panel.add((Component)this.labelDummy, gridBagConstraints);
        this.labelCHUV = new JLabel("Unit\u00e9 Universitaire Romande de N\u00e9phrologie P\u00e9diatrique-Site CHUV");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        this.panel.add((Component)this.labelCHUV, gridBagConstraints);
        this.getContentPane().add(this.panel);
    }

    public double computeEstimation() {
        Double d;
        Double d2;
        Double d3;
        Double d4;
        this.valid = Boolean.TRUE;
        double d5 = 0.0;
        double d6 = 0.0;
        d6 = this.comboboxSex.getSelectedIndex() == 1 ? 18.25 : 21.88;
        String string = this.TextFieldHeight.getText();
        try {
            d4 = new Double(string);
            if (string.isEmpty() || d4 < 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.TextFieldResult.setText("Please enter a valid height.");
            this.valid = Boolean.FALSE;
            return d5;
        }
        string = this.TextFieldCreatinine.getText();
        try {
            d3 = new Double(string);
            if (string.isEmpty() || d3 < 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.TextFieldResult.setText("Please enter a valid creatinine value.");
            this.valid = Boolean.FALSE;
            return d5;
        }
        string = this.TextFieldAge.getText();
        try {
            d2 = new Double(string);
            if (string.isEmpty() || d2 < 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.TextFieldResult.setText("Please enter a valid age.");
            this.valid = Boolean.FALSE;
            return d5;
        }
        string = this.TextFieldCystatin.getText();
        try {
            d = new Double(string);
            if (string.isEmpty() || d < 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.TextFieldResult.setText("Please enter a valid Cystatin value.");
            this.valid = Boolean.FALSE;
            return d5;
        }
        int n = this.comboboxCreatinine.getSelectedIndex();
        if (n == 0) {
            this.TextFieldResult.setText("Please select unit for creatinine.");
            this.valid = Boolean.FALSE;
            return d5;
        }
        d5 = n == 1 ? 0.42 * (d4 / d3) - 4.0E-4 * (d4 / d3) * (d4 / d3) - 14.52 * d + 0.69 * d2 + d6 : 37.16 * (d4 / d3) - 3.13 * (d4 / d3) * (d4 / d3) - 14.52 * d + 0.69 * d2 + d6;
        return d5;
    }

    public class EcouteurButtonCompute
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Double d = Window.this.computeEstimation();
            if (Window.this.valid) {
                Window.this.TextFieldResult.setText(d.toString());
            }
            Window.this.me.repaint();
        }
    }
}

