//----------------------------------------------------//
//        Program developed by Marc Petter            //
//                 Version 1.0                        //
//                   07.12.11                         //
//----------------------------------------------------//


import java.awt.event.ActionListener;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.GridBagLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.*;

import java.io.IOException;
import java.io.File;

import javax.swing.JTextField;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;


public class Window extends JFrame 
{
	private JTextField TextFieldHeight, TextFieldCreatinine, TextFieldAge, TextFieldCystatin, TextFieldResult;
	private JLabel labelSex, labelHeight, labelCm, labelCreatinine, labelAge,labelCystatin, labelYear, labelCHUV, labelDummy;
	private JComboBox comboboxCreatinine, comboboxSex;
	private boolean valid = Boolean.FALSE;
	private JButton buttonCompute;
	private Window me = this;
	private JPanel panel;
	
	
	public Window()
	{
		setTitle("Quadratic Formula for Glomerular Filtration Rate in Children");
		setBounds(0, 0, 650, 300);
		setResizable(Boolean.FALSE);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		panel = new JPanel();
		GridBagLayout gbl = new GridBagLayout();
		panel.setLayout(gbl);
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.insets = new Insets(4, 8, 4, 8);
		
		labelSex = new JLabel("Sex:");
		gbc.gridx = 0;
		gbc.gridy = 1;
		panel.add(labelSex, gbc);
		
		comboboxSex = new JComboBox(); 
		comboboxSex.addItem("Male");
		comboboxSex.addItem("Female");
		gbc.gridx = 1;
		gbc.gridy = 1;
		panel.add(comboboxSex, gbc);
		
		labelHeight = new JLabel("Height [cm]:");
		gbc.gridx = 0;
		gbc.gridy = 2;
		panel.add(labelHeight, gbc);
		
		TextFieldHeight = new JTextField(6);
		gbc.gridx = 1;
		gbc.gridy = 2;
		panel.add(TextFieldHeight, gbc);
		
		
		labelCreatinine = new JLabel("Creatinine:");
		gbc.gridx = 0;
		gbc.gridy = 3;
		panel.add(labelCreatinine, gbc);
		
		TextFieldCreatinine = new JTextField(6);
		gbc.gridx = 1;
		gbc.gridy = 3;
		panel.add(TextFieldCreatinine, gbc);
		
		comboboxCreatinine = new JComboBox(); 
		comboboxCreatinine.addItem("To select");
		comboboxCreatinine.addItem("mg/dl");
		comboboxCreatinine.addItem("mol/l");
		gbc.gridx = 2;
		gbc.gridy = 3;
		panel.add(comboboxCreatinine, gbc);
		
		labelAge = new JLabel("Age [years]:");
		gbc.gridx = 0;
		gbc.gridy = 4;
		panel.add(labelAge, gbc);

		labelCystatin = new JLabel("Cystatin C [mg/l]:");
		gbc.gridx = 0;
		gbc.gridy = 8;
		panel.add(labelCystatin, gbc);
		
		TextFieldAge = new JTextField(6);
		gbc.gridx = 1;
		gbc.gridy = 4;
		panel.add(TextFieldAge, gbc);
		
		TextFieldCystatin = new JTextField(6);
		gbc.gridx = 1;
		gbc.gridy = 8;
		panel.add(TextFieldCystatin, gbc);

		
		buttonCompute = new JButton("Compute");
		EcouteurButtonCompute earb = new EcouteurButtonCompute();
		buttonCompute.addActionListener(earb);
		gbc.gridx = 0;
		gbc.gridy = 9;
		panel.add(buttonCompute, gbc);
		
		TextFieldResult = new JTextField(20);
		gbc.gridx = 1;
		gbc.gridy = 9;
		panel.add(TextFieldResult, gbc);
		
		labelDummy = new JLabel(" ");
		gbc.gridx = 1;
		gbc.gridy = 8;
		panel.add(labelDummy, gbc);
			
		
		labelCHUV = new JLabel("Unit Universitaire Romande de Nphrologie Pdiatrique-Site CHUV");
		gbc.gridx = 1;
		gbc.gridy = 10;
		panel.add(labelCHUV, gbc);
			
		getContentPane().add(panel);
	}
	
	
	public class EcouteurButtonCompute implements ActionListener
	{
		public void actionPerformed(ActionEvent arg0)
		{
			Double result = computeEstimation();
			if(valid)
				TextFieldResult.setText(result.toString());
			
			me.repaint();
		}
	}
	
	public double computeEstimation()
	{
		valid = Boolean.TRUE;
		double result = 0.0;
		double k = 0.0;
		if(comboboxSex.getSelectedIndex() == 1)
			k = 18.25;
		else
			k = 21.88;
		
		String input = TextFieldHeight.getText();
		Double height;
		try
		{

			height = new Double(input);
			if(input.isEmpty() || height < 0.0)
				throw new NumberFormatException();
		}
		catch(NumberFormatException nfe)
		{
			TextFieldResult.setText("Please enter a valid height.");
			valid = Boolean.FALSE;
			return result;
		}
		
		input = TextFieldCreatinine.getText();
		Double creatinine;
		try
		{

			creatinine = new Double(input);
			if(input.isEmpty() || creatinine < 0.0)
				throw new NumberFormatException();
		}
		catch(NumberFormatException nfe)
		{
			TextFieldResult.setText("Please enter a valid creatinine value.");
			valid = Boolean.FALSE;
			return result;
		}

		input = TextFieldAge.getText();
		Double age;
		try
		{

			age = new Double(input);
			if(input.isEmpty() || age < 0.0)
				throw new NumberFormatException();
		}
		catch(NumberFormatException nfe)
		{
			TextFieldResult.setText("Please enter a valid age.");
			valid = Boolean.FALSE;
			return result;
		}

		input = TextFieldCystatin.getText();
		Double Cystatin;
		try
		{

			Cystatin = new Double(input);
			if(input.isEmpty() || Cystatin < 0.0)
				throw new NumberFormatException();
		}
		catch(NumberFormatException nfe)
		{
			TextFieldResult.setText("Please enter a valid Cystatin value.");
			valid = Boolean.FALSE;
			return result;
		}
		
		int index = comboboxCreatinine.getSelectedIndex();
		if(index == 0)
		{
			TextFieldResult.setText("Please select unit for creatinine.");
			valid = Boolean.FALSE;
			return result;
		}
		else if(index == 1)
		{
			result = 0.42*(height/creatinine) - 0.0004*(height/creatinine)*(height/creatinine) - 14.52*Cystatin + 0.69*age + k;
		}
		else
		{
			result = 37.16*(height/creatinine) - 3.13*(height/creatinine)*(height/creatinine) - 14.52*Cystatin + 0.69*age + k;
		}

		
		return result;
	}
	
}